# Compatibility shim so imports like `from ca_task_manager.repositories...`
# work even when you run app.py from the project root (without installing).
import os
import sys
import types

# Project root where folders `models/`, `repositories/`, `services/`, `ui_pages/`, `utils/` live
PROJECT_ROOT = os.path.dirname(os.path.dirname(__file__))

# Ensure project root is on sys.path
if PROJECT_ROOT not in sys.path:
    sys.path.insert(0, PROJECT_ROOT)

# Pre-register alias packages BEFORE anything imports them:
# This makes Python treat `ca_task_manager.<subpkg>` as real packages whose
# module search path points to your top-level folders.
for subpkg in ("models", "repositories", "services", "ui_pages", "utils"):
    pkg_name = f"ca_task_manager.{subpkg}"
    if pkg_name not in sys.modules:
        m = types.ModuleType(pkg_name)
        # Mark as a package by providing a path to the real folder
        m.__path__ = [os.path.join(PROJECT_ROOT, subpkg)]
        sys.modules[pkg_name] = m
